/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.query.VWExposedFieldTableModel;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWCheckBoxTableCellEditor;
import filenet.vw.toolkit.utils.table.VWCheckBoxTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class VWExposedFieldSelectionDialog
extends VWModalDialog
implements ActionListener {
    private VWQueueDefinition m_queueDef = null;
    private VWExposedFieldDefinition[] m_previouslySelectedFields = null;
    private JCheckBox m_systemFieldsCheckBox = null;
    private VWTable m_fieldTable = null;
    private VWExposedFieldTableModel m_fieldTableModel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWExposedFieldSelectionDialog(VWSessionInfo sessionInfo) {
        this(sessionInfo, false);
    }

    public VWExposedFieldSelectionDialog(VWSessionInfo sessionInfo, boolean bSingleSelection) {
        super(sessionInfo.getParentFrame());
        try {
            Dimension dim = VWStringUtils.stringToDimension("335,445");
            if (dim != null) {
                this.setSize(dim);
            } else {
                this.setSize(new Dimension(300, 400));
            }
            this.setTitle(VWResource.s_selectAField);
            this.createControls(sessionInfo, bSingleSelection);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWQueueDefinition queueDef, VWExposedFieldDefinition[] selectedFields) throws Exception {
        this.m_queueDef = queueDef;
        this.m_previouslySelectedFields = selectedFields;
        this.m_fieldTableModel.reinitialize(this.m_queueDef, this.m_previouslySelectedFields, this.m_systemFieldsCheckBox.isSelected());
    }

    public VWExposedFieldDefinition[] getSelectedFields() {
        return this.m_fieldTableModel.getSelectedFields();
    }

    public void releaseReferences() {
        if (this.m_systemFieldsCheckBox != null) {
            this.m_systemFieldsCheckBox.removeActionListener(this);
            this.m_systemFieldsCheckBox = null;
        }
        if (this.m_fieldTable != null) {
            this.m_fieldTable.removeAll();
            this.m_fieldTable = null;
        }
        if (this.m_fieldTableModel != null) {
            this.m_fieldTableModel.releaseResources();
            this.m_fieldTableModel = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source;
            if (this.m_fieldTable != null) {
                this.m_fieldTable.stopEditing();
            }
            if ((source = event.getSource()).equals(this.m_systemFieldsCheckBox)) {
                VWExposedFieldDefinition[] selectedFields = this.m_fieldTableModel.getSelectedFields();
                this.m_fieldTableModel.reinitialize(this.m_queueDef, this.m_previouslySelectedFields, this.m_systemFieldsCheckBox.isSelected());
                if (selectedFields != null) {
                    this.m_fieldTableModel.setSelectedFields(selectedFields);
                }
            } else if (source.equals(this.m_okButton)) {
                this.m_nExitStatus = 0;
                this.setVisible(false);
            } else if (source.equals(this.m_cancelButton)) {
                this.m_nExitStatus = 1;
                this.setVisible(false);
            } else if (source.equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_General + "bpfwd057.htm");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(VWSessionInfo sessionInfo, boolean bSingleSelection) {
        try {
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.getContentPane().add((Component)this.getMainPanel(sessionInfo, bSingleSelection), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel(VWSessionInfo sessionInfo, boolean bSingleSelection) {
        try {
            JPanel mainPanel = new JPanel(new BorderLayout(6, 6));
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.m_systemFieldsCheckBox = new JCheckBox(VWResource.s_showSystemFields);
            this.m_systemFieldsCheckBox.addActionListener(this);
            mainPanel.add((Component)this.m_systemFieldsCheckBox, "First");
            this.m_fieldTableModel = new VWExposedFieldTableModel(sessionInfo, bSingleSelection);
            this.m_fieldTable = new VWTable(this.m_fieldTableModel);
            this.m_fieldTable.setRowSelectionAllowed(true);
            if (bSingleSelection) {
                this.m_fieldTable.getSelectionModel().setSelectionMode(0);
            }
            this.m_fieldTable.setShowGrid(false);
            this.m_fieldTable.setRowHeight(26);
            VWAccessibilityHelper.setAccessibility(this.m_fieldTable, this, VWResource.s_availableFieldsList, VWResource.s_availableFieldsList);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.s_availableFieldsList), this.m_fieldTable);
            TableColumn tcElement = this.m_fieldTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                VWCheckBoxTableCellRenderer renderer = new VWCheckBoxTableCellRenderer();
                tcElement.setCellRenderer(renderer);
                tcElement.setCellEditor(new VWCheckBoxTableCellEditor());
            }
            mainPanel.add((Component)new JScrollPane(this.m_fieldTable), "Center");
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout());
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            buttonPanel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

